package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

import java.util.Map;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestCapriDocumentRuleEvaluator extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testOne() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		CapriDocumentRuleEvaluator testable = new CapriDocumentRuleEvaluator();
		
		// non-primary site
		Location site = Location.findById(2);
		
		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, site, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, site, false));
		
	}
	
	@Test
	public void testTwo() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		
		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);

		CapriDocumentRuleEvaluator testable = new CapriDocumentRuleEvaluator();
		
		Group ordGroup = DartObjectFactory.getInstance().getGroupDAO().findById(7);
		Group privacyGroup = DartObjectFactory.getInstance().getGroupDAO().findById(3);
		Group ndsGroup = DartObjectFactory.getInstance().getGroupDAO().findById(1);

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant1, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant1, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant2, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant3, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant3, false));

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ndsGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, ordGroup, participant4, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, privacyGroup, participant4, false));
	}

	@Test
	public void testThree() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		// non-primary site
		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		// request needs two participants
		Person pers1 = Person.findById(1004);  // primary investigator primary site
		Person pers2 = Person.findById(1005);  // primary site no data access
		Person pers3 = Person.findById(1006);  // primary investigator non-primary site
		Person pers4 = Person.findById(1008);  // non-primary site no data access
		Person pers5 = Person.findById(1014);  // non-primary site with data access
		
		Participant participant1 = Participant.create(pers1, req, primarySite, true, true, true);
		Participant participant2 = Participant.create(pers2, req, primarySite, false, false, false);
		Participant participant3 = Participant.create(pers3, req, site, true, true, true);
		Participant participant4 = Participant.create(pers4, req, site, false, false, false);
		Participant participant5 = Participant.create(pers5, req, site, true, true, false);

		CapriDocumentRuleEvaluator testable = new CapriDocumentRuleEvaluator();
		

		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant2, false));
		Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, participant4, false));

		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), participant1, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant1, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant1, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant1, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(43), participant1, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant1, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant1, false));
		
		// what about a principal investigator not at the primary site?
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), participant3, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant3, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant3, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant3, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(43), participant3, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant3, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant3, false));

		// what about an average participant with data access privileges?
		
		Assert.assertFalse(testable.isRequired(req, ds, map.get(4), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(5), participant5, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(9), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), participant5, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(18), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), participant5, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), participant5, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), participant5, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(43), participant5, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), participant5, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), participant5, false));
	}

	@Test
	public void testFour() throws Exception {
		
		Request req = TestAbstractDocumentRuleEvaluator.createARequest();
		
		DataSource ds = DartObjectFactory.getInstance().getDataSourceDAO().findById(1);
		
		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		Location site = Location.findById(2);
		Location primarySite = Location.findById(1);

		CapriDocumentRuleEvaluator testable = new CapriDocumentRuleEvaluator();
		
		//Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, site, false));	//As of 9/19/2014, 2 documents are required of all sites (not just the primary site)

		((DartRequest)req).setHipaaConsent(true);
		((DartRequest)req).setHipaaWaiver(true);
		
		//Assert.assertFalse(TestAbstractDocumentRuleEvaluator.anyDocumentTemplateRequired(testable, req, ds, site, false));	//As of 9/19/2014, HIPAA Waiver document required of all sites (not just the primary site)

		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(false);

		Map<Integer, DocumentTemplate> map = TestAbstractDocumentRuleEvaluator.getDocumentTemplateHash();
		
		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), primarySite, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));
		
		//As of 9/19/2014, 3 documents are required of all sites (not just the primary site)
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), site, false));
		
		
		((DartRequest)req).setHipaaConsent(true);

		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), primarySite, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(7), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(13), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));

		((DartRequest)req).setHipaaConsent(false);
		((DartRequest)req).setHipaaWaiver(true);

		Assert.assertTrue(testable.isRequired(req, ds, map.get(4), primarySite, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(6), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(7), primarySite, false)); 
		Assert.assertFalse(testable.isRequired(req, ds, map.get(8), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(10), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(11), primarySite, false));
		//Assert.assertFalse(testable.isRequired(req, ds, map.get(12), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(13), primarySite, false)); // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(14), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(15), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(16), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(17), primarySite, false));
		Assert.assertTrue(testable.isRequired(req, ds, map.get(18), primarySite, false));  // is required
		Assert.assertFalse(testable.isRequired(req, ds, map.get(19), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(20), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(21), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(22), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(23), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(24), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(25), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(26), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(27), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(28), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(29), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(30), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(31), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(32), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(33), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(34), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(35), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(36), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(37), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(38), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(39), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(40), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(41), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(42), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(43), primarySite, false));  
		Assert.assertFalse(testable.isRequired(req, ds, map.get(44), primarySite, false));
		Assert.assertFalse(testable.isRequired(req, ds, map.get(45), primarySite, false));
		
		//As of 9/19/2014, 3 documents are required of all sites (not just the primary site)
		Assert.assertTrue(testable.isRequired(req, ds, map.get(5), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(9), site, false));  // is required
		Assert.assertTrue(testable.isRequired(req, ds, map.get(13), site, false));	// is required
	}
}
